{  -*-  Tab-width:4 -*- }
{ File Nupi.p  - code to simulate Nupi commands.}
{*                                                                       *}
{*                                                                       *}
{*                      RESTRICTED RIGHTS LEGEND                         *}
{*                                                                       *}
{* Use, duplication, or disclosure by the Government is subject to       *}
{* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  *}
{* Technical Data and Computer Software clause at 252.227-7013.          *}
{*                                                                       *}
{*                    TEXAS INSTRUMENTS INCORPORATED.                    *}
{*                            P.O. BOX 149149                            *}
{*                         AUSTIN, TEXAS 78714-9149                      *}
{*                              MS 2151                                  *}
{*                                                                       *}
{*  Copyright (C)   1987,1988,1989,1990 Texas Instruments Incorporated.  *}
{*  All rights reserved.                                                 *}
{*                            											 *}

{  2-24-89  BJ  Added physical_to_virtual calls for AUX. }
{  3-13-89  BJ  Conditionalized pathnames for AUX. }
UNIT Nupi;
 
{ -ab Set at TRUE for LIMPET, FALSE for LASHUP }
{ -ab Set detault to LIMPET = TRUE }
{$SETC limpet := TRUE}			{*ab Set at TRUE for LIMPET, FALSE for LASHUP}
{$SETC SPYPORT := false}		{Inihibit reset for SPYPORT use}

INTERFACE

	USES 	memtypes, QuickDraw, OSIntf, ToolIntf, PackIntf, 
			Primitives, CommIntf, startupintf; 
	
	CONST
		IgnoreVolumeSize = $600000;		{Any volumes whose total byte capacity is less than this will be ignored.}
		MaxMcrLength		=	307200;		{300 * 1024.}
		NupiBlockSize = 1024;
		NupiBufferSize = 16384;
		MaxDisks = 14;		{Max number of disks NUPI can handle}
		StartDiskBlock = $1000;
		ArbitraryPartLength = 1000000;		{in blocks}

		{Partition Attributes}
		PA_LoadBand = 0;
		PA_MCRBand  = 1;
		PA_PageBand = 2;
		PA_FileBand = 3;
		PA_MetrBand = 4;
		PA_LogBand = 11;   (*DAB*)
 		
		{BOOT: Board Register offsets: }
		PCICommandReg	=	{$IFC limpet}   $C00008; {$ELSEC}	$D00004; {$ENDC}
		PCIStatusReg	=	{$IFC limpet}	$C0000C; {$ELSEC}	$C00004; {$ENDC} 
		MXBoardCtlReg	=	{$IFC limpet}	$C00004; {$ELSEC}	$C00000; {$ENDC}
		MXConfigReg		=	{$IFC limpet}	$C00004; {$ELSEC}	$D00000; {$ENDC}
		MXBootCode		=	$33;
		
		{BOOT: offsets simulated in lash up on memory board }
		MXNameReg		=		  0;
		MXStartReg		=		  4;
		MXSizeReg		=		  8;
		
		{*ab Boot Status values *}
		InitialStatus =      {$IFC limpet}     	0; {$ELSEC}        7; {$ENDC}
		SyncVal =	       			1;
		WarmBootStatus = 			3;
		StartLisp =	       			5;
        MicronetInitialized =    			6;      {*ab*}
		SWHalted =  				7;
		
		BadBlockAddress =	$84;		{ Read Nupi's error code }
		NupiErrorBit	=	$2000;

	
	TYPE
		PartName = STRING[4];
		PFMapEntry = PACKED RECORD
						StartBlock:		LongInt;
						Length:			LongInt;			{In Blocks}
						FileRefNum:		Integer;
						Attributes:		Integer;
						FileName:		String[31];
						PartitionName:	PartName;
						FileOpen:		Boolean;
						END;
		PFMap = PACKED ARRAY[1..100] of PFMapEntry;                     {ab 10/26/88}
		PFMapPtr = ^PFMap;
		VolumeArrayEntry = PACKED RECORD
							VolRefNum:		Integer;
							PhysUnit:		Integer;
							VolName:		STRING[27];
							DirectoryID:	LongInt;	{ID for Lispm directory}	
							PartFileMapPtr:	PFMapPtr;
							NumPFMapEnts:	Integer;
							MaxPFMapEnts:   Integer;    {ab 10/26/88. Max # of entries in the PFMap}
							END;
		VolumeArray = PACKED ARRAY [1..MaxDisks] of VolumeArrayEntry;
		
	VAR
		NupiBufferPtr: 				Ptr;
		VolumeArrayPtr:				^VolumeArray;
		NumVolumes:					Integer;			{Number of disk volumes in Volume Array}
		BootedLoad_VolumeIndex:		Integer;
		BootedLoad_PartIndex:		Integer;
		BootedMCR_VolumeIndex:		Integer;
		BootedMCR_PartIndex:		Integer;
		BootName:					str255;
		RealMCRLength:				longint;
		FoundLoad,FoundMCR:			Boolean;

		
    FUNCTION  c2pcopy(src: str255): str255;
	PROCEDURE NupiCommand(CmdWordPtr: Ptr);
	FUNCTION  InitNupi: Integer;
	FUNCTION  Bareboot: Boolean;
	FUNCTION  GetVolumeIndex(PhysUnit: Integer): Integer;
	PROCEDURE Writeln32b(str:str255; val:longint);
	PROCEDURE ClosePartFiles;
    PROCEDURE DoActUp;
    FUNCTION  GetCpuSLot: integer ;
    FUNCTION  set_ram_cache_mode(mode:boolean):boolean;
    PROCEDURE ParseFileName(FileNamePtr: StringPtr; var PartitionName: PartName; var PartAttrib: Integer);
	FUNCTION  aux_p: Boolean;

IMPLEMENTATION

    FUNCTION  aux_p: Boolean; external;
    PROCEDURE DoActUp; external;
	FUNCTION  GetCpuSlot; external;
	FUNCTION  set_ram_cache_mode; external;
	TYPE
	  NupiCmdBlk =	Packed RECORD
						Cmd:			Byte;
						EvtSctr:		Byte;
						Spare:			Byte;
						FmtUnit:		Byte;
						StatusWrd:		LongInt;
						UBuffPtr:		LongInt;
						XferCount:		LongInt; 
						DevBlkAddr:		LongInt;
						EventGenAddr:	LongInt;
					END;
			
	
FUNCTION c2pcopy(src: str255): str255;
{Make a pascal copy of a C string}
	VAR
		i,j:	integer;
		result:	StringPtr;
	BEGIN
		result := StringPtr(NewPtr(256));
		i := 0;
		WHILE ((src[i] <> chr(0)) AND (i < 256)) DO BEGIN
			j := i + 1;
			result^[j] := src[i];
			i := j;
			END;
		result^[0] := chr(i);
		c2pcopy := result^;
	END;

PROCEDURE ClosePartFiles;

	CONST
		SyncFlag = FALSE;

	VAR
		HPBlock:	HParamBlockRec;
		i,j:		Integer;
		PFMPtr:		PFMapPtr;
		FlushP:		Boolean;
		Error:		OSErr;

	BEGIN
		FOR i := 1 TO NumVolumes DO BEGIN
			{Writeln('Vol Index = ',i);}
			FlushP := FALSE;
			FOR j := 1 TO VolumeArrayPtr^[i].NumPFMapEnts DO BEGIN
				PFMPtr := VolumeArrayPtr^[i].PartFileMapPtr;
				IF PFMPtr <> NIL THEN BEGIN
					{Writeln('  FileName = ',PFMPtr^[j].FileName);}
					If (PFMPtr^[j].FileOpen = TRUE) THEN
						WITH HPBlock DO BEGIN
							ioCompletion := NIL;
							ioRefNum := PFMPtr^[j].FileRefNum;
							Error := PBClose(@HPBlock, SyncFlag);
							IF Error <> 0 THEN writeln('PBHClose Error ',error,' on ',PFMPtr^[j].FileName);
							FlushP := TRUE;
						END;
				END;
			END;
		{ NEED a PBFlushVol here on each volume that had a close to insure page band contents.  *MBC* 12.21.87 }
		{ IF (FlushP) THEN BEGIN  ... setup ParamBlk  ioNamePtr, ioVRefNum, & ioCompletion, and call ...}
		END;
	END;

					
PROCEDURE ParseFileName(FileNamePtr: StringPtr; var PartitionName: PartName; var PartAttrib: Integer);

(* If file name is of the form xxxx.yyyy, where yyyy is LOAD, MCR,
    PAGE, or FILE, then the file is a partition file and its partition
	name and attributes are returned. The first four characters of 
	the file name are returned as the partition name.  
	If the file is not a partition file the value -1 is returned
	for the Partition Attributes. *)

	VAR
		i,j,result:	Integer;
		PerIndex:	Integer;
		SuffixLen:	Integer;
		NameLen:	Integer;
		Suffix:		String[4];
	
	BEGIN														{ParseFileName}
		FOR i := 1 TO 4 DO PartitionName[i] := ' ';			{Prefill with blanks}
		PartAttrib := -1;			
		IF FileNamePtr <> NIL THEN BEGIN
			NameLen := Length(FileNamePtr^);
			IF NameLen > 4 THEN BEGIN
					SuffixLen := 0;
					FOR PerIndex := 1 TO NameLen DO BEGIN		{Find "." character}
					IF FileNamePtr^[PerIndex] = '.' THEN BEGIN
						SuffixLen := NameLen - PerIndex;
						LEAVE;
						END;
				END;
				IF ((PerIndex > 1) AND (SuffixLen > 2)) AND (SuffixLen < 5) THEN BEGIN
					FOR i := 1 TO PerIndex - 1 DO BEGIN
						j := i;					{For bumps i one too many times.}
						PartitionName[i] := FileNamePtr^[i];
						IF i > 3 THEN LEAVE;	{truncate to four chars}
					END;
					PartitionName[0] := Chr(j);
					j := 1;
					FOR i := PerIndex + 1 TO NameLen DO BEGIN
						Suffix[j] := FileNamePtr^[i];
						j := j + 1;
					END;
					Suffix[0] := char(SuffixLen);
					result := RelString(Suffix,'MCR',FALSE,FALSE);
					IF result = 0 THEN PartAttrib := PA_MCRBand;
					result := RelString(Suffix,'LOAD',FALSE,FALSE);
					IF result = 0 THEN PartAttrib := PA_LoadBand;
					result := RelString(Suffix,'PAGE',FALSE,FALSE);
					IF result = 0 THEN PartAttrib := PA_PageBand;
					result := RelString(Suffix,'FILE',FALSE,FALSE);
					IF result = 0 THEN PartAttrib :=  PA_FileBand;
					result := RelString(Suffix,'METR',FALSE,FALSE);
					IF result = 0 THEN PartAttrib :=  PA_MetrBand;
					result := RelString(Suffix,'LOG' ,FALSE ,FALSE);  (*DAB*)
					IF result = 0 THEN PartAttrib := PA_LogBand;
					{UprString(Suffix,FALSE);  didn't work...}

				END;											{IF PerIndex}
			END;												{IF NameLen}
		END;													{IF FileNamePtr}
	END;														{ParseFileName}

PROCEDURE BuildPFMap(PartFileMapPtr: PFMapPtr; var NumPartitions: Integer; VolRefNum: Integer;
						DirectoryID: Integer);
						
	CONST
		SyncFlag = FALSE;

	VAR
		i,j:			Integer;
		Error:			OSErr;
		CIPBlock:		CInfoPBRec;
		Name:			STR255;
		NextBlock:		LongInt;
		PartName:		PartName;
		PartAttrib:  	Integer;
		
	BEGIN													{BuildPFMap}
							{It is assumed that we are in 24 bit mode when called}
		NEXTBLOCK := StartDiskBlock;
		j := 1;
		WITH CIPBlock DO BEGIN	
			FOR i := 1 TO NumPartitions DO BEGIN
				ioCompletion := NIL;
				ioNamePtr := @Name;
				ioVRefNum := VolRefNum;
				ioDirID := DirectoryID;
				ioFDirIndex := i;
				Error := PBGetCatInfo(@CIPBlock, SyncFlag);
				IF Error <> 0 THEN PrtWarnMesg('Error on PBGetCatInfo', Error)
				ELSE BEGIN
					IF BitTst(@ioFlAttrib,3) = FALSE THEN BEGIN	{Not a Directory}
						ParseFileName(@Name, PartName, PartAttrib);
						IF PartAttrib >= 0 THEN BEGIN				{One of our's}
							WITH PartFileMapPtr^[j] DO BEGIN
								StartBlock := NextBlock;
								Length := ioFlLgLen DIV NupiBlockSize;
								FileRefNum := 0;
								PartitionName := PartName;
								FileName := Name;
								Attributes := PartAttrib;
								FileOpen := FALSE;
								NextBlock := NextBlock + ArbitraryPartLength;
							END;								{WITH PartFileMapPtr}
						j := j + 1;
						END;									{IF PartAttrib}
					END;										{IF BitTst}
				END;											{ELSE}
			END;											{FOR}
		END;												{WITH CIPBlock}
		NumPartitions := j - 1;			{Return actual # partition files}
	END;													{BuildPFMap}
					
FUNCTION BuildPartFileMaps: boolean;

	CONST
		SyncFlag = FALSE;

	VAR
		i:				Integer;
		Error:			OSErr;
		DirName:		STRING[15];
		CIPBlock:		CInfoPBRec;
		PartFileMapPtr:	PFMapPtr;
		TempPtr:		Ptr;
		DirectoryID:	LongInt;
		VolRefNum:		Integer;
		NumPartitions:	Integer;
		MaxPartitions:  Integer;

	BEGIN													{BuildPartitionFileMaps}
		(* This procedure assumes the Volume Array has already been built and
			we are in 24 bit mode when called *)
	BuildPartFileMaps := TRUE;  {ok so far}
	REPEAT  { for error exits }
		
		FOR i := 1 TO NumVolumes DO BEGIN
			WITH CIPBlock DO BEGIN
				ioCompletion := NIL;
				if aux_p then DirName := 'users/microexp' else DirName := 'microExp';
				ioNamePtr := @DirName;
				ioFDirIndex := 0;
				ioDrDirID := 0;
				ioFRefNum := 0;
				VolRefNum := VolumeArrayPtr^[i].VolRefNum;
				ioVRefNum := VolRefNum;
				Error := PBGetCatInfo(@CIPBlock, SyncFlag);
				IF Error <> 0 THEN BEGIN		{Lispm directory does not exist on this volume}
					VolumeArrayPtr^[i].PartFileMapPtr := NIL;
					VolumeArrayPtr^[i].NumPFMapEnts := 0;
				END
				ELSE BEGIN					{Lispm directory exists}
					DirectoryID := ioDrDirID;
					VolumeArrayPtr^[i].DirectoryID := DirectoryID;
					MaxPartitions := MAX(ioDrNmFls + 2, 32);                        {ab 10/26/88. Hopefully this size will ensure}
																					{that some new partition files can be created dynamically.}
					NumPartitions := ioDrNmFls;    
					TempPtr := NewPtr(SizeOf (PFMapEntry) * MaxPartitions);          {ab 10/26/88.  Use MaxPartitions instead of NumPartitions}
					IF (TempPtr = NIL) THEN
						BEGIN
						PrtErrorMesg(213,0) ;	{ Memory allocation failed in Disk initializations }
						BuildPartFileMaps := FALSE;
						Leave;
						END;
					PartFileMapPtr := PFMapPtr(TempPtr);
					VolumeArrayPtr^[i].PartFileMapPtr := PartFileMapPtr;
				
					BuildPFMap(PartFileMapPtr, NumPartitions, VolRefNum, DirectoryID);
					{BuildPFMap returns actual # of partition files in this microExp directory in NumPartitions}
		            VolumeArrayPtr^[i].NumPFMapEnts := NumPartitions;
					VolumeArrayPtr^[i].MaxPFMapEnts := MaxPartitions;
				END;											{ELSE}
			END;												{WITH}
		END;													{FOR}
	UNTIL TRUE = TRUE;   {Errors exit to here}
	END;														{BuildPartitionFileMaps}
	
PROCEDURE IncPhysUnit(var DiskUnit: Integer);

	VAR
		Formatter:	LongInt;
		UnitNum:	LongInt;

	BEGIN														{IncPhysUnit}
		Formatter := BSR(DiskUnit, 3);
		UnitNum := BAND(DiskUnit, 1);
		IF UnitNum = 0 THEN UnitNum := 1
		ELSE BEGIN
			UnitNum := 0;
			Formatter := Formatter + 1;
			IF Formatter = 5 THEN Formatter := 6;	{Formatter 5 dedicated for NUPI}
		END;
		Formatter := BSL(Formatter, 3);
		DiskUnit := LoWord(BOR(Formatter, UnitNum));
	END;														{IncPhysUnit}
					
FUNCTION BuildVolumeArray: Boolean;

	CONST
		SyncFlag = FALSE;

	VAR
		i:				Integer;
		Error:			OSErr;
		Name:			STR255;
		PBlock:			HParamBlockRec;
		DiskUnit:		Integer;
		blks,total:		longint;

	BEGIN															{BuildVolumeArray}
							{It is assumed that we are in 24 bit mode when called}
	  BuildVolumeArray := TRUE;
	  New(VolumeArrayPtr);		{Get memory for Volume Array}
	  IF VolumeArrayPtr = NIL THEN
		BEGIN
		BuildVolumeArray := FALSE;
  		PrtErrorMesg(213,0) ;	{ Memory allocation failed in Disk initializations }
	  	END
	  ELSE
		BEGIN
		NumVolumes := 0;
		DiskUnit := 0;
		FOR i := 1 TO MaxDisks DO BEGIN
			WITH PBlock DO BEGIN
				ioCompletion :=  NIL;  	{no completion routine ==> no initiate}
				ioNamePtr := @Name;
				ioVolIndex := i;
				Error := PBHGetVInfo(@PBlock, SyncFlag);
				IF Error <> 0 THEN BEGIN
					LEAVE;	{Volume i does not exist or has an error}
					END;
				blks := ioVNmAlBlks;
				IF blks < 0 THEN
					blks := $10000 + blks;
				total := blks * ioVAlBlkSiz;
			{	If Total >= IgnoreVolumeSize THEN BEGIN}
					NumVolumes := NumVolumes + 1;
					VolumeArrayPtr^[NumVolumes].VolRefNum := ioVRefNum;
					VolumeArrayPtr^[NumVolumes].VolName := ioNamePtr^;
					VolumeArrayPtr^[NumVolumes].PhysUnit := DiskUnit;
					VolumeArrayPtr^[NumVolumes].PartFileMapPtr := NIL;
			{		END;}
				IncPhysUnit(DiskUnit);
			END;								{WITH PBlock}
		END;									{FOR}
	  END;
	END;															{BuildVolumeArray}


FUNCTION FindBootBand(targetname: PartName; targetvolume: str255; MCR_P: boolean): BOOLEAN;
{ Find the band, targetname, on the targetvolume.  When found set either 
the MCR or the LOAD global Booted__Index vars depending on MCR_P.  Return success boolean.
Note: targetvolume of empty string means any volume.} 
	VAR
		volume,name:	str255;
		i,j,result:		Integer;
		NumPartitions:	Integer;
		PFMPtr:			PFMapPtr;

	BEGIN
		FindBootBand := FALSE;
		FOR i := 1 TO NumVolumes DO BEGIN
			result := RelString(VolumeArrayPtr^[i].VolName,targetvolume,FALSE,FALSE);
			IF ((result = 0) OR (targetvolume = '')) THEN BEGIN
				NumPartitions := VolumeArrayPtr^[i].NumPFMapEnts;
				FOR j := 1 TO NumPartitions DO BEGIN
					PFMPtr := VolumeArrayPtr^[i].PartFileMapPtr;
					result := RelString(PFMPtr^[j].PartitionName,targetname,FALSE,FALSE);
					IF result = 0 THEN BEGIN
						FindBootBand := TRUE;
						IF MCR_P = TRUE THEN BEGIN
							BootedMCR_VolumeIndex := i;
							BootedMCR_PartIndex:= j;
						END
						ELSE BEGIN
							BootedLoad_VolumeIndex := i;
							BootedLoad_PartIndex := j;
						END;
						LEAVE;
					END;
				END;
			END;
		END;
	END;

PROCEDURE FindDefaultBands;

	VAR
		i,j:			Integer;
		NumPartitions:	Integer;
		PFMPtr:			PFMapPtr;

	BEGIN
		IF (foundload <> TRUE) THEN foundload := FindBootBand('lod1','',FALSE);
		IF (foundmcr <> TRUE) THEN foundmcr := FindBootBand('mcr1','',TRUE);
		writeln('Attempt to find defaults.');
{		IF NOT FoundLoad THEN PrtWarnMesg('LOD1 not found',0); }
{		IF NOT FoundMCR THEN PrtWarnMesg('MCR1 not found',0); }
	END;

	
PROCEDURE FindStartupBands;
	VAR
		startup_tbl_ptr:	Ptr;
		Pname:			PartName;
		templ:			longint;
		i,j,PartAttrib:	Integer;
		s1:				str255;
		SMcrName,SLoadName,SMcrVolume,SLoadVolume:	str255;
	BEGIN
		startup_tbl_ptr := read_startup;
		templ := longint(startup_tbl_ptr);
		if (templ <> 0) THEN BEGIN
		
			s1 := startup_mcrname(startup_tbl_ptr);	
			SMcrName := c2pcopy(s1);
			ParseFileName(@SMcrName, PName, PartAttrib);
			If PartAttrib = PA_MCRBand THEN
				SMcrName := Pname;
			{writeln('Boot MCR name =',SMcrName);}

			s1 := startup_loadname(startup_tbl_ptr);
			SLoadName := c2pcopy(s1);
			ParseFileName(@SLoadName, PName, PartAttrib);
			If PartAttrib = PA_LoadBand THEN
				SLoadName := Pname;
			{writeln('Boot load name =',SLoadName);}
			
			s1 := startup_mcrvolume(startup_tbl_ptr);
			SMcrVolume := c2pcopy(s1);
			{writeln('Mcr volume =',SMcrVolume);}

			s1 := startup_loadvolume(startup_tbl_ptr);
			SLoadVolume := c2pcopy(s1);
			{writeln('Load volume =',SLoadVolume);}
			
			foundload := FindBootBand(SLoadName,SLoadVolume,FALSE);
			foundmcr := FindBootBand(SMcrName,SMcrVolume,TRUE);
{			IF NOT FoundLoad THEN PrtWarnMesg('Load band not found',0); }
			IF NOT FoundLoad THEN writeln('Load band, ',SLoadName,', not found.');
{			IF NOT FoundMCR THEN PrtWarnMesg('Mcr band not found',0); }
			IF NOT FoundMCR THEN writeln('Mcr band, ',SMcrName,', not found.');
			
			IF ((foundload <> TRUE) OR (foundmcr <> TRUE)) THEN BEGIN
				writeln('Bands from startup not found.');
				FindDefaultBands;
				END;

		END
		ELSE
		BEGIN
			writeln('Startup file not found.');
			FindDefaultBands;
		END;
	END;

	
PROCEDURE wait(ticks: longint);		{wait ticks 60ths of a second.}
	VAR
		T1,T3:		LONGINT;
	BEGIN
		t1 := tickcount;	{now}
		t1 := t1 + ticks;	{goal}
		REPEAT
			DoActUp;
			t3 := tickcount;	{hang}
		UNTIL t1 < t3;			{until goal exceeded}
	END;
	
{*ab*}
FUNCTION GetBootStatus: integer;
	VAR
		tempi:			integer;
	BEGIN
		{* Read Board Control Register *}
		tempi := nubus_read_byte(GetCpuSlot, MXBoardCtlReg);
		
		{* Boot status is bits 4-7 in LIMPET, bits 0-3 in LASHUP *}
		{$IFC limpet} 
			tempi := BSR(tempi,4); {$ENDC}
		GetBootStatus := BAND(tempi, 15);
	END;
	
{*ab*}
FUNCTION NeedsResetP: Boolean;
	VAR
		BootStatus:			integer;
	BEGIN
	{If BootStatus is the initial value or the software halted value, we need to cold boot}
		BootStatus := GetBootStatus;
		IF ((BootStatus = InitialStatus) OR (BootStatus = SWHalted))
			THEN NeedsResetP := TRUE
			ELSE NeedsResetP := False;
	END;

FUNCTION waitcomsync: Boolean;
	CONST
		SyncMaxWait	=		10;	{timeout reset}
	VAR
		Nseconds:					longint;
		Status:						integer;
	BEGIN
		waitcomsync := TRUE;  {everything ok}
		Nseconds := SyncMaxWait * 10;
		REPEAT 
			status := GetBootStatus;
			wait(6);	{wait 1/10 second}
			nseconds := nseconds - 1;
		UNTIL (((Status >= SyncVal) AND (Status < SWHalted)) OR (Nseconds <= 0));
		IF ((Status >= SyncVal) AND (Status < SWHalted)) THEN 
			{writeln('Sync Complete')}
			status := status	{NOP instead of writ sync complete}
		ELSE
		   BEGIN
		   PrtErrorMesg(219, status);		{'SYNC timed out, status ='}
		   waitcomsync := FALSE;  {Failure}
		   END;
	END;


{ This apparently doesn't wait for the reset here.  It fires off self test which is
ignored by the resetting MX, then waits and when reset completes, ignores the response
since PCICommandReg indicates only command in progress/completion. }
FUNCTION ResetMX: Boolean;
	CONST
		ResetMaxWait	=		20;	{timeout reset !!!RJG} {Make this very long for now. *BJ*}
	VAR
		LongValue,Nseconds:			longint;
		CPU_Slot: integer ;
	BEGIN
		CPU_Slot := GetCpuSlot ;
		nubus_write(CPU_Slot, MXConfigReg, 0);     {lash-up: quit nubus master operations :::RJG}
  	{$IFC SPYPORT}
		writeln('SPYPORT: Not Resetting');
	{$ELSEC}		
		writeln('Resetting');
		nubus_write(CPU_Slot, MXConfigReg, 7); 		{RESET,fault LED, and BUSY :::RJG}
		nubus_write(CPU_Slot, PCICommandReg, $77);      {load non-zero value into command register :::RJG}
	{$ENDC}
		Nseconds := ResetMaxWait * 10;
		REPEAT 
		  	LongValue := nubus_read_byte(CPU_Slot, PCICommandReg);
			wait(6);	{wait 1/10 second}
			nseconds := nseconds - 1;
		UNTIL ((LongValue = 0) OR (Nseconds <= 0));
		{writeln('Reset nscec=',nseconds,'  Readbyte=',longvalue);}
		IF LongValue = 0 THEN
			BEGIN								{ :::RJG}
			   LongValue := nubus_read_byte(CPU_Slot, PCIStatusReg);	{ :::RJG}
			   IF LongValue = 0 THEN					{ :::RJG}
					BEGIN
						{writeln('Reset finished sucessfully');}
						ResetMX := TRUE
				  	END
				  ELSE							{ :::RJG}
						BEGIN
						PrtErrorMesg(220,LongValue);		{'microExplorer reset error = ' :::RJG}
						ResetMX := FALSE;				{ :::RJG}
						END;							{ :::RJG}
			END								{ :::RJG}
			ELSE
			   BEGIN
			   PrtErrorMesg(216,0); {reset timed out}
			   ResetMX := FALSE;
			   END;
			
	END;
	
FUNCTION SelfTestMX(TestNumber: longint): longint;		
	{Returns zero, self test error < $FF, or $100 for timeout}
	CONST
		STestMaxWait	=		20;		{timeout any/all self test}
		TimedOut		=		$100;	{Failed due to TimeOut}
	VAR
		LongValue,Nseconds:		longint;
		CPU_Slot:				integer ;
	BEGIN
		{writeln('Run self test');}
		CPU_Slot := GetCpuSlot ;
		nubus_write(CPU_Slot, PCIStatusReg, TestNumber);  	{All self tests}
		nubus_write(CPU_Slot, PCICommandReg, $11); 	{Execute self tests  ?? $22 w/parms}
		Nseconds := STestMaxWait * 10;
		REPEAT 
			LongValue := nubus_read_byte(CPU_Slot, PCICommandReg);
			wait(6);	
			nseconds := nseconds - 1;
		UNTIL ((LongValue = 0) OR (Nseconds <= 0));
		{writeln('Selftest nscec=',nseconds,'  Readbyte=',longvalue);}
		SelfTestMX := nubus_read_byte(CPU_Slot, PCIStatusReg);			{:::RJG}
		IF LongValue <> 0 THEN
			SelfTestMX := TimedOut;
	END;

FUNCTION ReadMCR(VolumeIndex,PartIndex: integer; StartAddress: Ptr): boolean;
	{load mcr code}
	CONST
		SyncFlag = TRUE;		{for file I/O do things NON-Initiated }
	VAR 
		FileRefNum,i,tempi:		Integer;
		Error:				OSErr;
		PBlock:				ParamBlockRec;
		HPBlock:			HParamBlockRec;
		PFMPtr:				PFMapPtr;
		Result:				boolean;
		
	BEGIN
		result := TRUE;	
		PFMPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
		i := PartIndex;
		WITH HPBlock DO BEGIN		{ using i index into volume data structure, open a file }
			ioCompletion := NIL;
			ioNamePtr := @PFMPtr^[i].FileName;
			ioVRefNum := VolumeArrayPtr^[VolumeIndex].VolRefNum;
			ioVersNum := 0; 
			ioPermssn := fsRdPerm;
			ioMisc := NIL;
			ioDirID := VolumeArrayPtr^[VolumeIndex].DirectoryID;
			Error := PBHOpen(@HPBlock, SyncFlag);
			IF Error <> 0 THEN BEGIN
				PrtErrorMesg(221, Error);   {'Error opening MCR file'}
				result := FALSE;
				END
			 ELSE BEGIN
				PFMPtr^[i].FileRefNum := ioRefNum;
				PFMPtr^[i].FileOpen := TRUE;
				END;
			 END;		{WITH HPBlock}
		IF result = TRUE THEN
			BEGIN	
				FileRefNum := PFMPtr^[i].FileRefNum;

				WITH PBlock DO BEGIN		{ Read from filerefnum }
					ioCompletion :=  NIL;  	{no completion routine ==> no initiate}
					ioRefNum := FileRefNum;
					ioBuffer := StartAddress;
					ioReqCount := MaxMcrLength; 
					ioPosMode := fsFromStart;
					ioPosOffset := 0;
					Error := PBRead(@PBlock, SyncFlag);
					IF ((Error <> 0) and (Error <> eofErr)) THEN
						BEGIN
							result := FALSE;
							PrtErrorMesg(222, Error); {'Error reading MCR file'}
						END;
					RealMCRLength := ioActCount;
					bootname := PFMPtr^[i].FileName;
					Error := PBClose(@PBlock, SyncFlag);
					IF Error <> 0 THEN 
							writeln('Error on PBClose ',error)
						else 					
							PFMPtr^[i].FileOpen := false;
				END;			{WITH PBlock}
			END;
			ReadMCR := Result;
	END;
			
FUNCTION bareboot: Boolean;
	CONST
		MXRegMask		=	$000000FF;
		SyncFlag = TRUE;		{for file I/O do things NON-Initiated }
		BootMaxWait 	=		2;	{timeout #x33 boot}
		ErrorAlert		=	100 ;
	VAR 
		TempL,adrtemp:						longint;
		SelfTestErr,Nseconds:				longint;
		i,tempi:							Integer;
		NeedsReset,ResetOK,ReadOK,Bareboot_Result:			boolean;
		StartAddress:			PTR;
		MEM_Slot:							integer ;
		CPU_Slot:							integer ;
		StartAdrMask:						longint ;
	BEGIN

	REPEAT							{Just here so LEAVE can be used - we never repeat!}
		{Remember lispm.p is calling bareboot only IF MCR is present}
	
	    {AB 2.2.88  Leave in NeedsReset check for Lashup}
		CPU_Slot := GetCpuSlot ;
	{$IFC limpet}
		NeedsReset := TRUE;
		MEM_Slot := CPU_Slot ;
	{$ELSEC}
		MEM_Slot := $0C ;
		NeedsReset := NeedsResetP;
	{$ENDC}

		StartAdrMask := BOR(BSL(longint(MEM_Slot), 24), $F0000000) ;
		
		IF NeedsReset = FALSE THEN
			BEGIN
				writeln('No Reset: already booted.');
				Bareboot_Result := TRUE;
				Leave;
	  		END;
			

		Bareboot_Result := FALSE;		{init to bareboot didn't work. MBC 2.5.88}
	
		IF ((foundload <> TRUE) OR (foundmcr <> TRUE)) THEN BEGIN
				{$IFC limpet}
					PrtErrorMesg(201,0) ;	{ Load Band or Microcode Missing }
				{$ELSEC}
					Bareboot_Result := TRUE ;
				{$ENDC}
				Leave;
			END;
			
		ResetOK := ResetMX;
		IF ResetOK = FALSE THEN
		   Leave;   {Error message has already been displayed}

		{test NuBus data paths to board by rippling a 1 from bit 00-31	:::RJG}
		TempL := 1;							{starting pattern = 00000001 :::RJG}
		readok := TRUE;							{:::RJG}		
		REPEAT								{:::RJG}
			nubus_write(MEM_Slot, 0, TempL);  			{write test pattern :::RJG}
	  		SelfTestErr := nubus_read(MEM_Slot, 0); 		{read test pattern :::RJG}
			IF SelfTestErr <> TempL THEN			       	{:::RJG}
			    BEGIN					       	{:::RJG}
				PrtErrorMesg(207,0);  {'unable to write/read memory on board' :::RJG need error msg!!!}
				ReadOK := FALSE;
				Leave;					       	{:::RJG}
			    END;					       	{:::RJG}
			TempL := BSL(TempL, 1);			       		{:::RJG}
		UNTIL (TempL = 0);						{:::RJG}		
		If (ReadOK = FALSE) THEN Leave;					{:::RJG}		


		SelfTestErr := SelfTestMX(4);		{ask it to run NOP test to validate communication :::RJG}
		IF SelfTestErr <> 0 THEN 
			BEGIN
				PrtErrorMesg(208,SelfTestErr) ;	{microexplorer SelfTestErr-old'208:board does not respond to commands :::RJG}
				Leave;
			END;

      		{get the start address}
	  	adrtemp := nubus_read(MEM_Slot, MXStartReg);

		adrtemp := BOR(adrtemp, StartAdrMask);	     {*ab temp, F not coming thru in Fs*}

		StartAddress := Ptr(adrtemp);
		TempL := BAND(adrtemp, StartAdrMask);

	  	IF (TempL <> StartAdrMask) THEN		{verify the address - it should be $FCxxxxxx}
			BEGIN
	 			PrtErrorMesg(223,adrtemp); {'Start address looks bad = '}
				leave;
			END;
		StartAddress := physical_to_virtual(ptr32to24(StartAddress));		{convert 32 address to 24 }
		
		ReadOK := ReadMCR(BootedMCR_VolumeIndex,BootedMCR_PartIndex,StartAddress);

	  	IF ReadOK = FALSE THEN
			BEGIN
				PrtErrorMesg(203,0) ;			{ MCR read failed }
				leave;
			END;
		
		{set mxstate to unbooted  ...later}
		nubus_write(MEM_Slot,MXSizeReg,RealMCRLength); 

		{TempL := longint(bootname);}
		
		TempL := $41414141;		{anything to be sure parity gets set}
		nubus_write(MEM_Slot,MXNameReg,TempL);

		TempL := 0;
		nubus_write(CPU_Slot,PCIStatusReg,TempL); 
		{writeln('Wrote 0 to PCIStatusReg', TempL);}

		writeln('Booting mcr ',VolumeArrayPtr^[BootedMCR_VolumeIndex].VolName,':microExp:',BootName);		{moved up :::RJG}
		TempL := MXBootCode;
		nubus_write(CPU_Slot,PCICommandReg,TempL);
		{writeln('Wrote to PCICommandReg', TempL);}
		
		Nseconds := bootmaxwait * 10;
		REPEAT 
		  	tempi := nubus_read_byte(CPU_Slot, PCICommandReg);
			wait(6);	{wait 1/10 second}
			nseconds := nseconds - 1;
		UNTIL ((tempi = 0) OR (Nseconds <= 0));		
		IF tempi <> 0 THEN PrtErrorMesg(209,0);		 {'Boot CMD Timed Out'}
		tempi := nubus_read_byte(CPU_Slot, PCIStatusReg);		
		IF tempi <> 0 THEN
			BEGIN
			    PrtErrorMesg(210,0); {boot of mcr failed}
			    writeln('Boot of microcode status = ',tempi);	{:::RJG need error msg!!!}
			    Leave;						{:::RJG}
			END;							{:::RJG}
		
		if not waitcomsync THEN
		   leave; {It failed and printed its own error message}
		Bareboot_Result := TRUE;
		
	UNTIL TRUE = TRUE;		{NEVER repeat!}
	bareboot := Bareboot_Result;
	END;

		
FUNCTION InitNupi: Integer;

	VAR
		i:				Integer;
		Error:			OSErr;
		LogEOF:			LongInt;
		NumBlocks:		LongInt;
		FileName:		Str255;
		VolumeName:		Str255;
		vRefNum: 		integer;
		FileRefNum: 	integer;
		
{	GLOBAL VARIABLES: NupiBufferPtr }
		
	BEGIN													{InitNupi}
	        InitNupi := 0;
						{It is assumed that we are in 24 bit mode when called}
	  REPEAT
		NupiBufferPtr := NewPtr(NupiBufferSize);			{Allocate Nupi Buffer}
		if NupiBufferPtr = NIL THEN
		   BEGIN
		   PrtErrorMesg(213,0) ;	{ Memory allocation failed in Disk initializations }
		   InitNupi := -1;
		   Leave;
		   END;


		if not BuildVolumeArray THEN
			BEGIN
			InitNupi := -1;
			Leave;
			END;

		IF not BuildPartFileMaps THEN
			BEGIN
			InitNupi := -1;
			Leave;
			END;
		FindStartupBands;
	  UNTIL TRUE = TRUE;
	END;													{InitNupi}
	
FUNCTION GetVolumeIndex(PhysUnit: Integer): Integer;

	VAR
		Formatter:	LongInt;
		UnitNum:	LongInt;
		temp:		Integer;

	BEGIN													{GetVolumeIndex}
		Formatter := BSR(PhysUnit, 2);
		UnitNum := BAND(PhysUnit, 1);
		Temp := LoWord(BOR(Formatter, UnitNum));
		IF Temp > 11 THEN
			Temp := Temp - 1
		ELSE Temp := Temp + 1;
		IF Temp > NumVolumes THEN
			PrtWarnMesg('Bad Physical device #',PhysUnit);
		GetVolumeIndex := Temp;
	END;		{GetVolumeIndex}


PROCEDURE writeln32b(str:str255; val:longint);
	VAR mmu: signedbyte;
	BEGIN
		MMU := mmu24mode;
		SwapMMUMode(MMU);
		writeln(str, val);
		SwapMMUMode(MMU);
	END;


PROCEDURE NupiCommand(CmdWordPtr: Ptr);
	CONST
		BuffSize = NupiBufferSize;		{Size of Nupi buffer}
		FromStart =	1;			{Positioning mode = from start of file}
		SyncFlag = FALSE;		{No synchronous I/O, yet}
		
	VAR
	  	MMU:				SignedByte;
		locNupiCmdBlk:		NupiCmdBlk;		{local copy of the command word}
		PostEventFlag:		BOOLEAN;		{Flag for whether we need to post an event}
		ScatterFlag:		BOOLEAN;		{Flag for whether scatter bit is set.}
		ScatterPtr:			LongInt;		{Address of Scatter Table}
		ScatterEntry:		PACKED RECORD	{Scatter Table Entry}
								Address: LongInt;
								Length: LongInt;
								END;
		RNS:				PACKED Array [0..30] of LongInt;	{Used by Request NUPI Status}
		Temp:				Integer;
		i,j:				Integer;
		FileRefNum:			Integer;
		DeviceError:		Integer;
		Message:			Integer;
		Error:				OSErr;
		TempLong:			LongInt;
		BuffCount:			LongInt;
		BuffAvail:			LongInt;
		PartDisp:			LongInt;
		CurrSELength:		LongInt;
		CurrSEAddress:		LongInt;
		ByteCount:			LongInt;
		WordCount:			LongInt;
		TempPtr,tptr:		Ptr;
		TempBuffPtr:		Ptr;
		PBlock:				ParamBlockRec;
		HPBlock:			HParamBlockRec;
		PartFileMapPtr:		PFMapPtr;
		VolumeIndex:		Integer;
		NumFormatters:		Integer;
		Found:				Boolean;
        bdump:			    boolean;
        old_ram_cache_mode: boolean;

{	GLOBAL VARIABLES: PartFileMapPtr, NupiBufferPtr }


	BEGIN
	{It is assumed that this procedure is called in 24 bit mode with a 32 bit physical memory pointer}
	
	    CmdWordPtr := physical_to_virtual(CmdWordPtr); {Do the mapping for AUX. }

		MMU := mmu32mode;
		SwapMMUMode(MMU);					{Switch to 32 bit mode}
		ByteSwap(CmdWordPtr,@locNupiCmdBlk,24);	{Copy and swap command block}
		StatusPtr := Ptr(ORD4(CmdWordPtr) + 7); {**AB** Set up status ptr *}
		BitSet(StatusPtr,0);					{Set busy bit}
		SwapMMUMode(MMU);					{Switch to 24 bit mode}
		DeviceError := 0;						{ status of this IO so far }
		
	WITH locNupiCmdBlk DO BEGIN
		REPEAT		{just here so LEAVE will exit}
			temp := EvtSctr;
			ScatterFlag := BitTst(@temp,9);			{Bits numbered left to right in halfword}
			PostEventFlag := BitTst(@temp,8);
			
			CASE Cmd of				{NUPI command}
			  $02:PrtWarnMesg('Request Device Status',Cmd);		{Request Device Status}
			  $10:writeln32b('Restore Device Command',Cmd);	{Restore Device}
			  $11:PrtWarnMesg('Seek Command',Cmd);				{Seek}
			  $12:BEGIN			{Read}

				{writeln('Begining read, command block = ', ord4(CmdWordPtr));}
			  	
				IF FmtUnit = $FF THEN BEGIN		{Optimization for Booted Load Band}
					VolumeIndex := BootedLoad_VolumeIndex;
					PartFileMapPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
					i := BootedLoad_PartIndex;
					PartDisp := DevBlkAddr;			{Block Addr is partition relative}
				END
				ELSE BEGIN
					{Find Partition-to-File Map Entry}
					VolumeIndex := GetVolumeIndex(Integer(FmtUnit));
					PartFileMapPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
					IF PartFileMapPtr = NIL THEN BEGIN
						writeln32b('No Partitions on this volume ',VolumeIndex);
						DeviceError := BadBlockAddress;
						leave;
					END;
					Found := FALSE;
					FOR i := 1 TO VolumeArrayPtr^[VolumeIndex].NumPFMapEnts DO BEGIN
						PartDisp := DevBlkAddr - PartFileMapPtr^[i].StartBlock;
						IF (PartDisp >= 0) AND (PartDisp < PartFileMapPtr^[i].Length) THEN BEGIN
							Found := TRUE;
							LEAVE;
						END;
					END;;
					IF NOT Found THEN BEGIN
						writeln('No such block number (READ)', devblkaddr);
						writeln('Phys Unit', FmtUnit);
						DeviceError := BadBlockAddress;
						leave;
					END;
				END;							{ELSE}
				
				
				IF NOT PartFileMapPtr^[i].FileOpen THEN BEGIN
					WITH HPBlock DO BEGIN
						
						ioCompletion := NIL;
						ioNamePtr := @PartFileMapPtr^[i].FileName;
						ioVRefNum := VolumeArrayPtr^[VolumeIndex].VolRefNum;
						IF PartFileMapPtr^[i].Attributes = PA_PageBand THEN
							ioPermssn := fsRdWrPerm			{Exclusive access}
						ELSE 
							IF PartFileMapPtr^[i].Attributes = PA_LoadBand THEN
							    BEGIN
								writeln('Load Band   ',VolumeArrayPtr^[VolumeIndex].VolName,
										':microExp:',PartFileMapPtr^[i].FileName);
								ioPermssn := fsRdPerm;
								END
							ELSE
								ioPermssn := fsRdWrShPerm;		{Shared access}
						ioMisc := NIL;
						ioDirID := VolumeArrayPtr^[VolumeIndex].DirectoryID;
						Error := PBHOpen(@HPBlock, SyncFlag);
						IF Error <> 0 THEN
							BEGIN
							PrtErrorMesg(224, Error);  {'Error on PBHOpen'}
							DeviceError := BadBlockAddress; {Error; force crash}
							END;
						{Writeln('Load band opened.');}
						PartFileMapPtr^[i].FileRefNum := ioRefNum;
						PartFileMapPtr^[i].FileOpen := TRUE;
					END;										{WITH HPBlock}
				END;											{IF file not open}
				
				FileRefNum := PartFileMapPtr^[i].FileRefNum;
				
				PartDisp := PartDisp * NupiBlockSize;	{Convert to byte displacement}
				
				IF ScatterFlag THEN ScatterPtr := Ord4(physical_to_virtual(Ptr(UBuffPtr)))
				ELSE ScatterPtr := Ord4(CmdWordPtr) + 8; 

				CurrSELength := 0;
				
				WHILE XferCount > 0 DO BEGIN
					IF XferCount > BuffSize THEN BuffCount := BuffSize
					ELSE BuffCount := XferCount;
					
					{Read from disk into MAC buffer}
					WITH PBlock DO BEGIN
						ioCompletion :=  NIL;  	{no completion routine ==> no initiate}
						ioRefNum := FileRefNum;
						ioBuffer := NupiBufferPtr;
						ioReqCount := BuffCount;
						ioPosMode := FromStart;
						ioPosOffset := PartDisp;
						{writeln('Getting ready to read');}
						old_ram_cache_mode := set_ram_cache_mode(TRUE);
						Error := PBRead(@PBlock, SyncFlag);
						old_ram_cache_mode := set_ram_cache_mode(old_ram_cache_mode);
						{writeln('Read complete');}
						IF Error <> 0 THEN
							BEGIN
							PrtErrorMesg(225, Error);  {'Error on PBRead'}
							DeviceError := BadBlockAddress;   {Error; force crash}
							END;
					END;								{WITH PBlock}
					
					XferCount := XferCount - BuffCount;
					PartDisp := PartDisp + BuffCount;	{Adjust Partition Displacement}
					TempBuffPtr := NupiBufferPtr;
					
					{Move words from MAC buffer to Addin board memory}
					MMU := mmu32mode;
					SwapMMUMode(MMU);					{Switch to 32 bit mode}
					WHILE BuffCount > 0 DO BEGIN
						IF CurrSELength = 0 THEN BEGIN
							ByteSwap(Ptr(ScatterPtr),@ScatterEntry,8);	{Get Scatter Table Entry}
							CurrSEAddress := ord4(physical_to_virtual(ptr(ScatterEntry.Address))); {AUX mapping. *BJ*}
							{writeln('Scatter entry = ', CurrSEAddress);}
							CurrSELength := ScatterEntry.Length;
							ScatterPtr := ScatterPtr + 8;		{Access next Scatter Table Entry}
						END;
						IF BuffCount < CurrSELength THEN
							ByteCount := BuffCount
						ELSE ByteCount := CurrSELength;
						{writeln('Getting ready to block move from ', ord4(TempBuffPtr), ' to ', CurrSEAddress);}
						MoveWrds(TempBuffPtr,Ptr(CurrSEAddress),ByteCount);
						{writeln('Block move complete');}
						BuffCount := BuffCount - ByteCount;
						CurrSELength := CurrSELength - ByteCount;
						CurrSEAddress := CurrSEAddress + ByteCount;
						TempBuffPtr := Ptr(ORD4(TempBuffPtr) + ByteCount);
					END;					{WHILE BuffCount > 0}
					MMU := mmu24mode;
					SwapMMUMode(MMU);					{Switch back to 24 bit mode}

				END;							{WHILE XferCount > 0}
			  {Writeln('Read complete');}
			  END; {of Read}
						
			  $13: BEGIN				{Write}
				
				IF FmtUnit = $FF THEN BEGIN		{Optimization for Booted Load Band}
					VolumeIndex := BootedLoad_VolumeIndex;
					PartFileMapPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
					i := BootedLoad_PartIndex;
					PartDisp := DevBlkAddr;		{Block Addr is partition relative}
				END
				ELSE BEGIN
					{Find Partition to File Map Entry}
					VolumeIndex := GetVolumeIndex(Integer(FmtUnit));
					PartFileMapPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
					IF PartFileMapPtr = NIL THEN BEGIN
						writeln32b('No Partitions on this volume',VolumeIndex);
						DeviceError := BadBlockAddress;
						leave;
					END;
					Found := FALSE;
					FOR i := 1 TO VolumeArrayPtr^[VolumeIndex].NumPFMapEnts DO BEGIN
						PartDisp := DevBlkAddr - PartFileMapPtr^[i].StartBlock;
						IF (PartDisp >= 0) AND (PartDisp < PartFileMapPtr^[i].Length) THEN BEGIN
							Found := TRUE;
							LEAVE;
						END;
					END;;
					IF NOT Found THEN BEGIN
						writeln('No such block number (WRITE)', devblkaddr);
						writeln('Phys Unit', FmtUnit);
						DeviceError := BadBlockAddress;
						leave;
					END;
				END;								{ELSE}
				
				IF NOT PartFileMapPtr^[i].FileOpen THEN BEGIN
					WITH HPBlock DO BEGIN
						ioCompletion := NIL;
						ioNamePtr := @PartFileMapPtr^[i].FileName;
						ioVRefNum := VolumeArrayPtr^[VolumeIndex].VolRefNum;
						IF PartFileMapPtr^[i].Attributes = PA_PageBand THEN
							ioPermssn := fsRdWrPerm			{Exclusive access}
						ELSE 
							ioPermssn := fsRdWrShPerm;		{Shared access}
						ioMisc := NIL;
						ioDirID := VolumeArrayPtr^[VolumeIndex].DirectoryID;
						Error := PBHOpen(@HPBlock, SyncFlag);
						IF Error <> 0 THEN
							BEGIN
							PrtErrorMesg(224, Error); {error on open}
							DeviceError := BadBlockAddress; {Error; force crash}
							END;
						PartFileMapPtr^[i].FileRefNum := ioRefNum;
						PartFileMapPtr^[i].FileOpen := TRUE;
					END;										{WITH HPBlock}
				END;											{IF file not open}
				
				FileRefNum := PartFileMapPtr^[i].FileRefNum;
				PartDisp := PartDisp * NupiBlockSize;	{Convert to byte displacement}
				
				IF ScatterFlag THEN ScatterPtr := Ord4(physical_to_virtual(Ptr(UBuffPtr)))
				ELSE ScatterPtr := Ord4(CmdWordPtr) + 8;
				CurrSELength := 0;
				
				WHILE XferCount > 0 DO BEGIN
					IF XferCount > BuffSize THEN BuffCount := BuffSize
					ELSE BuffCount := XferCount;
					TempBuffPtr := NupiBufferPtr;
					BuffAvail := BuffCount;
					
					{Move words from Addin board memory to MAC buffer}
					MMU := mmu32mode;
					SwapMMUMode(MMU);					{Switch to 32 bit mode}
					WHILE BuffAvail > 0 DO BEGIN
						IF CurrSELength = 0 THEN BEGIN
							ByteSwap(Ptr(ScatterPtr),@ScatterEntry,8);	{Get Scatter Entry}
							CurrSEAddress := ord4(physical_to_virtual(ptr(ScatterEntry.Address))); {AUX mapping. *BJ*}
							CurrSELength := ScatterEntry.Length;
							ScatterPtr := ScatterPtr + 8;		{Access next Scatter Entry}
						END;
						IF BuffAvail < CurrSELength THEN
							ByteCount := BuffAvail
						ELSE ByteCount := CurrSELength;
						MoveWrds(Ptr(CurrSEAddress),TempBuffPtr,ByteCount);
						BuffAvail := BuffAvail - ByteCount;
						CurrSELength := CurrSELength - ByteCount;
						CurrSEAddress := CurrSEAddress + ByteCount;
						TempBuffPtr := Ptr(ORD4(TempBuffPtr) + ByteCount);
					END;					{WHILE BuffAvail > 0}
					SwapMMUMode(MMU);					{Switch back to 24 bit mode}
						
					{Write from MAC buffer to disk}
					WITH PBlock DO BEGIN
						ioCompletion :=  NIL;  	{no completion routine ==> no initiate}
						ioRefNum := FileRefNum;
						ioBuffer := NupiBufferPtr;
						ioReqCount := BuffCount;
						ioPosMode := FromStart;
						ioPosOffset := PartDisp;
						old_ram_cache_mode := set_ram_cache_mode(TRUE);
						Error := PBWrite(@PBlock, SyncFlag);
						IF Error <> 0 THEN
							if (PartFileMapPtr^[i].Attributes = PA_LoadBand) AND (Error = wrPermErr) THEN
								BEGIN 			{Saving over current band  close/ open RdWR and retry}
								{PrtWarnMesg('Attempting save on current band',0);}
								Error := PBClose(@PBlock, SyncFlag);
								IF Error <> 0 THEN PrtWarnMesg('Error on Load Band Close',Error);
								WITH HPBlock DO BEGIN {reopen}
									ioCompletion := NIL;
									ioNamePtr := @PartFileMapPtr^[i].FileName;
									ioVRefNum := VolumeArrayPtr^[VolumeIndex].VolRefNum;
									ioPermssn := fsRdWrPerm;
									ioMisc := NIL;
									ioDirID := VolumeArrayPtr^[VolumeIndex].DirectoryID;
									Error := PBHOpen(@HPBlock, SyncFlag);
									IF Error <> 0 THEN 
										BEGIN
										PrtErrorMesg(226, Error);  {'Load Band Write Protected'}
										DeviceError := BadBlockAddress;  {Error;}
										END;
									PartFileMapPtr^[i].FileRefNum := ioRefNum;
									PartFileMapPtr^[i].FileOpen := TRUE;
									END;
								ioCompletion :=  NIL;  	{no completion routine ==> no initiate}
								ioRefNum := PartFileMapPtr^[i].FileRefNum;
								Error := PBWrite(@PBlock, SyncFlag);
								IF Error <> 0 THEN
									PrtWarnMesg('Error on Write Retry', Error);
								END
							ELSE
							    BEGIN
								PrtErrorMesg(227, Error); {'Error on PBWrite'}
								DeviceError := BadBlockAddress; { Error; force crash}
								END;
						old_ram_cache_mode := set_ram_cache_mode(old_ram_cache_mode);
	
					END;								{WITH PBlock}
					
					XferCount := XferCount - BuffCount;
					PartDisp := PartDisp + BuffCount;	{Adjust Partition Displacement}
				END;						{WHILE XferCount > 0}
			  END; {of write}
					
				$81:;					{Nupi Setup}
				
				$82: BEGIN				{Request NUPI Status}
						FOR i := 0 TO 30 DO RNS[i] := 0;
						FOR i := 2 TO 8 DO RNS[i] := $10000000;	{All formatters offline}
						NumFormatters := NumVolumes DIV 2;
						IF Odd(NumVolumes) THEN NumFormatters := NumFormatters + 1;
						FOR j := 1 TO NumFormatters DO 
							RNS[j + 1] := 0;					{Mark online formatters}
						FOR i := 9 TO 22 DO RNS[i] := $F0000000;	{All devices offline}
						FOR j := 1 TO NumVolumes DO 
							RNS[j + 8] := $40000000;			{Mark online devices}
						MMU := mmu32mode;
						SwapMMUMode(MMU);					{Switch to 32 bit mode}
						ByteSwap(@RNS[0],physical_to_virtual(Ptr(UBuffPtr)),XferCount);
						SwapMMUMode(MMU);					{Switch back to 24 bit mode}
					 END;
					
				OTHERWISE BEGIN
					Writeln32b('Unknown command',Cmd);
					PrtWarnMesg('Nupi/Formatter Command',Cmd);  {Nupi or Formatter command}
				END;
							
			END; {of Case}
		UNTIL TRUE = TRUE;		{NEVER repeat!}
								{ Errors exit to here }

		{WriteLn('Nupi operation complete, error = ', DeviceError, 'Starting cleanup');}
		MMU := mmu32mode;
		SwapMMUMode(MMU);					{Switch to 32 bit mode}
		IF (DeviceError <> 0) THEN BEGIN
			TempLong :=  BSL(DeviceError,8);		{Shift it into device error field}
			TempPtr := Ptr(Ord4(CmdWordPtr) + 4);
			Tptr := @TempLong;
			ByteSwap(Tptr,TempPtr,4);			{Stuff it in Limpet's copy of RQB}
			BitSet(StatusPtr,2);				{Set Error bit}
			END;
		BitClr(StatusPtr,0);					{Clear busy bit}	
		CmdComplete(StatusPtr);
		IF PostEventFlag THEN					{Check Event option}
			BEGIN
				TempPtr := physical_to_virtual(Ptr(EventGenAddr));
				TempPtr^ := -1;					{Post Event}
			END;
		SwapMMUMode(MMU);					{Switch to 24 bit mode}
		END;									{WITH locNupiCmdBlk}
		{writeln('Nupi cleanup complete');}
	END; {of NupiCommand}
	
END.